//: concurrency/Interrupting.java
// Przerywanie zablokowanego wtku.
import java.util.concurrent.*;
import java.io.*;
import static net.mindview.util.Print.*;

class SleepBlocked implements Runnable {
  public void run() {
    try {
      TimeUnit.SECONDS.sleep(100);
    } catch(InterruptedException e) {
      print("InterruptedException");
    }
    print("Opuszczanie metody SleepBlocked.run()");
  }
}

class IOBlocked implements Runnable {
  private InputStream in;
  public IOBlocked(InputStream is) { in = is; }
  public void run() {
    try {
      print("Oczekiwanie na read():");
      in.read();
    } catch(IOException e) {
      if(Thread.currentThread().isInterrupted()) {
        print("Przerwany w zawieszeniu na operacji wejcia-wyjcia");
      } else {
        throw new RuntimeException(e);
      }
    }
    print("Opuszczanie metody IOBlocked.run()");
  }
}

class SynchronizedBlocked implements Runnable {
  public synchronized void f() {
    while(true) // Nigdy nie zwalnia blokady
      Thread.yield();
  }
  public SynchronizedBlocked() {
    new Thread() {
      public void run() {
        f(); // Blokada pozyskana przez ten wtek
      }
    }.start();
  }
  public void run() {
    print("Prba wywoania f()");
    f();
    print("Opuszczanie metody SynchronizedBlocked.run()");
  }
}

public class Interrupting {
  private static ExecutorService exec =
    Executors.newCachedThreadPool();
  static void test(Runnable r) throws InterruptedException{
    Future<?> f = exec.submit(r);
    TimeUnit.MILLISECONDS.sleep(100);
    print("Przerywanie " + r.getClass().getName());
    f.cancel(true); // Przerwanie, jeli dziaa
    print("Nakaz przerwania wysany do " + r.getClass().getName());
  }
  public static void main(String[] args) throws Exception {
    test(new SleepBlocked());
    test(new IOBlocked(System.in));
    test(new SynchronizedBlocked());
    TimeUnit.SECONDS.sleep(3);
    print("Opuszczanie programu (System.exit(0))");
    System.exit(0); // ... dwa ostatnie przerwania zawiody
  }
} /* Output: (95% match)
Przerywanie SleepBlocked
InterruptedException
Opuszczanie metody SleepBlocked.run()
Nakaz przerwania wysany do SleepBlocked
Oczekiwanie na read():
Przerywanie IOBlocked
Nakaz przerwania wysany do IOBlocked
Pba wywoania f()
Przerywanie SynchronizedBlocked
Nakaz przerwania wysany do SynchronizedBlocked
Opuszczanie programu (System.exit(0))
*///:~
