//: concurrency/CountDownLatchDemo.java
import java.util.concurrent.*;
import java.util.*;
import static net.mindview.util.Print.*;

// Realizuje pewn cz zadania:
class TaskPortion implements Runnable {
  private static int counter = 0;
  private final int id = counter++;
  private static Random rand = new Random(47);
  private final CountDownLatch latch;
  TaskPortion(CountDownLatch latch) {
    this.latch = latch;
  }
  public void run() {
    try {
      doWork();
      latch.countDown();
    } catch(InterruptedException ex) {
      // Dopuszczalny tryb koczenia zadania
    }
  }
  public void doWork() throws InterruptedException {
    TimeUnit.MILLISECONDS.sleep(rand.nextInt(2000));
    print(this + "zakoczone");
  }
  public String toString() {
    return String.format("%1$-3d ", id);
  }
}

// Oczekiwanie na egzemplarzu CountDownLatch:
class WaitingTask implements Runnable {
  private static int counter = 0;
  private final int id = counter++;
  private final CountDownLatch latch;
  WaitingTask(CountDownLatch latch) {
    this.latch = latch;
  }
  public void run() {
    try {
      latch.await();
      print("Przejcie bariery zatrzaskowej przez " + this);
    } catch(InterruptedException ex) {
      print(this + " przerwane");
    }
  }
  public String toString() {
    return String.format("zadanie WaitingTask %1$-3d ", id);
  }
}

public class CountDownLatchDemo {
  static final int SIZE = 100;
  public static void main(String[] args) throws Exception {
    ExecutorService exec = Executors.newCachedThreadPool();
    // Wszystkie zadania musz wspdzieli pojedynczy obiekt CountDownLatch:
    CountDownLatch latch = new CountDownLatch(SIZE);
    for(int i = 0; i < 10; i++)
      exec.execute(new WaitingTask(latch));
    for(int i = 0; i < SIZE; i++)
      exec.execute(new TaskPortion(latch));
    print("Wszystkie zadania uruchomione");
    exec.shutdown(); // Wyjcie po zakoczeniu wszystkich zada
  }
} /* (Execute to see output) *///:~
