//: concurrency/CaptureUncaughtException.java
import java.util.concurrent.*;

class ExceptionThread2 implements Runnable {
  public void run() {
    Thread t = Thread.currentThread();
    System.out.println("wywoanie run() dla " + t);
    System.out.println(
      "pow = " + t.getUncaughtExceptionHandler());
    throw new RuntimeException();
  }
}

class MyUncaughtExceptionHandler implements
Thread.UncaughtExceptionHandler {
  public void uncaughtException(Thread t, Throwable e) {
    System.out.println("przechwycono " + e);
  }
}

class HandlerThreadFactory implements ThreadFactory {
  public Thread newThread(Runnable r) {
    System.out.println(this + " tworzy nowy obiekt Thread");
    Thread t = new Thread(r);
    System.out.println("utworzono " + t);
    t.setUncaughtExceptionHandler(
      new MyUncaughtExceptionHandler());
    System.out.println(
      "pow = " + t.getUncaughtExceptionHandler());
    return t;
  }
}

public class CaptureUncaughtException {
  public static void main(String[] args) {
    ExecutorService exec = Executors.newCachedThreadPool(
      new HandlerThreadFactory());
    exec.execute(new ExceptionThread2());
  }
} /* Output: (90% match)
HandlerThreadFactory@de6ced tworzy nowy obiekt Thread
utworzono Thread[Thread-0,5,main]
pow = MyUncaughtExceptionHandler@1fb8ee3
run() by Thread[Thread-0,5,main]
pow = MyUncaughtExceptionHandler@1fb8ee3
przechwycono java.lang.RuntimeException
*///:~
