//: annotations/AtUnitExample2.java
// Asecie i wyjtki w metodach testujcych.
package annotations;
import java.io.*;
import net.mindview.atunit.*;
import net.mindview.util.*;

public class AtUnitExample2 {
  public String methodOne() {
    return "Metoda methodOne";
  }
  public int methodTwo() {
    System.out.println("Metoda methodTwo");
    return 2;
  }
  @Test void assertExample() {
    assert methodOne().equals("Metoda methodOne");
  }
  @Test void assertFailureExample() {
    assert 1 == 2: "Co za niespodzianka!";
  }
  @Test void exceptionExample() throws IOException {
    new FileInputStream("nofile.txt"); // Zrzuca wyjtek
  }
  @Test boolean assertAndReturn() {
    // Assercja z komunikatem:
    assert methodTwo() == 2: "Metoda methodTwo powinna zwraca 2";
    return methodOne().equals("Metoda methodOne");
  }
  public static void main(String[] args) throws Exception {
    OSExecute.command(
      "java net.mindview.atunit.AtUnit AtUnitExample2");
  }
} /* Output:
annotations.AtUnitExample2
  . assertExample 
  . assertFailureExample java.lang.AssertionError: Co za niespodzianka!
(nieudany)
  . exceptionExample java.io.FileNotFoundException: nofile.txt (System nie moe odnale okrelonego pliku)
(nieudany)
  . assertAndReturn Metoda methodTwo

(4 test(y)(w))

>>> 2 NIEUDANE(-NYCH) <<<
  annotations.AtUnitExample2: assertFailureExample
  annotations.AtUnitExample2: exceptionExample
*///:~
