//: annotations/AtUnitExample1.java
package annotations;
import net.mindview.atunit.*;
import net.mindview.util.*;

public class AtUnitExample1 {
  public String methodOne() {
    return "Metoda methodOne";
  }
  public int methodTwo() {
    System.out.println("Metoda methodTwo");
    return 2;
  }
  @Test boolean methodOneTest() {
    return methodOne().equals("Metoda methodOne");
  }
  @Test boolean m2() { return methodTwo() == 2; }
  @Test private boolean m3() { return true; }
  // Shows output for failure:
  @Test boolean failureTest() { return false; }
  @Test boolean anotherDisappointment() { return false; }
  public static void main(String[] args) throws Exception {
    OSExecute.command(
      "java net.mindview.atunit.AtUnit AtUnitExample1");
  }
} /* Output:
annotations.AtUnitExample1
  . methodOneTest 
  . m2 Metoda methodTwo

  . m3 
  . failureTest (nieudany)
  . anotherDisappointment (nieudany)
(5 test(y)(w))

>>> 2 NIEUDANE(-NYCH) <<<
  annotations.AtUnitExample1: failureTest
  annotations.AtUnitExample1: anotherDisappointment
*///:~
