//: typeinfo/SnowRemovalRobot.java
import java.util.*;

public class SnowRemovalRobot implements Robot {
  private String name;
  public SnowRemovalRobot(String name) {this.name = name;}
  public String name() { return name; }
  public String model() { return "niegoBot Seria 11"; }
  public List<Operation> operations() {
    return Arrays.asList(
      new Operation() {
        public String description() {
          return name + " szufluje, odniea";
        }
        public void command() {
          System.out.println(name + " - szuflowanie");
        }
      },	
      new Operation() {
        public String description() {
          return name + " kruszy ld";
        }
        public void command() {
          System.out.println(name + " - kruszenie");
        }
      },
      new Operation() {
        public String description() {
          return name + " czyci dachy";
        }
        public void command() {
          System.out.println(name + " - czyszczenie");
        }
      }
    );
  }	
  public static void main(String[] args) {
    Robot.Test.test(new SnowRemovalRobot("Slusher"));
  }
} /* Output:
Nazwa robota: Slusher
Model robota: niegoBot Seria 11
Slusher szufluje, odniea
Slusher - szuflowanie
Slusher kruszy ld
Slusher - kruszenie
Slusher czyci dachy
Slusher - czyszczenie
*///:~
