//: typeinfo/ModifyingPrivateFields.java
import java.lang.reflect.*;

class WithPrivateFinalField {
  private int i = 1;
  private final String s = "Jestem zupenie bezpieczny";
  private String s2 = "A ja jestem bezpieczny?";
  public String toString() {
    return "i = " + i + ", " + s + ", " + s2;
  }
}

public class ModifyingPrivateFields {
  public static void main(String[] args) throws Exception {
    WithPrivateFinalField pf = new WithPrivateFinalField();
    System.out.println(pf);
    Field f = pf.getClass().getDeclaredField("i");
    f.setAccessible(true);
    System.out.println("f.getInt(pf): " + f.getInt(pf));
    f.setInt(pf, 47);
    System.out.println(pf);
    f = pf.getClass().getDeclaredField("s");
    f.setAccessible(true);
    System.out.println("f.get(pf): " + f.get(pf));
    f.set(pf, "Nie, nie jeste!");
    System.out.println(pf);
    f = pf.getClass().getDeclaredField("s2");
    f.setAccessible(true);
    System.out.println("f.get(pf): " + f.get(pf));
    f.set(pf, "Nie, nie jeste!");
    System.out.println(pf);
  }
} /* Output:
i = 1, Jestem zupenie bezpieczny, A ja jestem bezpieczny?
f.getInt(pf): 1
i = 47, Jestem zupenie bezpieczny, A ja jestem bezpieczny?
f.get(pf): Jestem zupenie bezpieczny
i = 47, Jestem zupenie bezpieczny, A ja jestem bezpieczny?
f.get(pf): A ja jestem bezpieczny?
i = 47, Jestem zupenie bezpieczny, Nie, nie jeste!
*///:~
