//: typeinfo/HiddenImplementation.java
// Wymijanie blokady w postaci dostpu pakietowego.
import typeinfo.interfacea.*;
import typeinfo.packageaccess.*;
import java.lang.reflect.*;

public class HiddenImplementation {
  public static void main(String[] args) throws Exception {
    A a = HiddenC.makeA();
    a.f();
    System.out.println(a.getClass().getName());
    // Bd kompilacji: cannot find symbol 'C':
    /* if(a instanceof C) {
      C c = (C)a;
      c.g();
    } */
    // Oho! Mechanizm refleksji wci pozwala na wywoanie g():
    callHiddenMethod(a, "g");
    // A nawet jeszcze mniej dostpnych metod!
    callHiddenMethod(a, "u");
    callHiddenMethod(a, "v");
    callHiddenMethod(a, "w");
  }
  static void callHiddenMethod(Object a, String methodName)
  throws Exception {
    Method g = a.getClass().getDeclaredMethod(methodName);
    g.setAccessible(true);
    g.invoke(a);
  }
} /* Output:
publiczna metoda C.f()
typeinfo.packageaccess.C
publiczna metoda C.g()
pakietowa metoda C.u()
chroniona metoda C.v()
prywatna metoda C.w()
*///:~
