//: typeinfo/AnonymousImplementation.java
// Nawet klasa anonimowa nie zabezpiecza przed refleksj.
import typeinfo.interfacea.*;
import static net.mindview.util.Print.*;

class AnonymousA {
  public static A makeA() {
    return new A() {
      public void f() { print("publiczna metoda C.f()"); }
      public void g() { print("publiczna metoda C.g()"); }
      void u() { print("pakietowa metoda C.u()"); }
      protected void v() { print("chroniona metoda C.v()"); }
      private void w() { print("prywatna metoda C.w()"); }
    };
  }
}	

public class AnonymousImplementation {
  public static void main(String[] args) throws Exception {
    A a = AnonymousA.makeA();
    a.f();
    System.out.println(a.getClass().getName());
    // Refleksja i tak udostpni klas anonimow:
    HiddenImplementation.callHiddenMethod(a, "g");
    HiddenImplementation.callHiddenMethod(a, "u");
    HiddenImplementation.callHiddenMethod(a, "v");
    HiddenImplementation.callHiddenMethod(a, "w");
  }
} /* Output:
publiczna metoda C.f()
AnonymousA$1
publiczna metoda C.g()
pakietowa metoda C.u()
chroniona metoda C.v()
prywatna metoda C.w()
*///:~
