//: strings/ThreatAnalyzer.java
import java.util.regex.*;
import java.util.*;

public class ThreatAnalyzer {
  static String threatData =
    "58.27.82.161@02/10/2005\n" +
    "204.45.234.40@02/11/2005\n" +
    "58.27.82.161@02/11/2005\n" +
    "58.27.82.161@02/12/2005\n" +
    "58.27.82.161@02/12/2005\n" +
    "[Nastpna sekcja rejestru z innym formatem danych]";
  public static void main(String[] args) {
    Scanner scanner = new Scanner(threatData);
    String pattern = "(\\d+[.]\\d+[.]\\d+[.]\\d+)@" +
      "(\\d{2}/\\d{2}/\\d{4})";
    while(scanner.hasNext(pattern)) {
      scanner.next(pattern);
      MatchResult match = scanner.match();
      String ip = match.group(1);
      String date = match.group(2);
      System.out.format("Atak dnia %s z %s\n", date,ip);
    }
  }
} /* Output:
Atak dnia 02/10/2005 z 58.27.82.161
Atak dnia 02/11/2005 z 204.45.234.40
Atak dnia 02/11/2005 z 58.27.82.161
Atak dnia 02/12/2005 z 58.27.82.161
Atak dnia 02/12/2005 z 58.27.82.161
*///:~
