//: strings/JGrep.java
// Bardzo prosta wersja programu "grep".
// {Args: JGrep.java "\\b[Ssct]\\w+"}
import java.util.regex.*;
import net.mindview.util.*;

public class JGrep {
  public static void main(String[] args) throws Exception {
    if(args.length < 2) {
      System.out.println("Stosowanie: java JGrep plik wyraenieRegularne");
      System.exit(0);
    }
    Pattern p = Pattern.compile(args[1]);
    // Przegld kolejnych wierszy pliku wejciowego:
    int index = 0;
    Matcher m = p.matcher("");
    for(String line : new TextFile(args[0])) {
      m.reset(line);
      while(m.find())
        System.out.println(index++ + ": " +
          m.group() + ": " + m.start());
    }
  }
} /* Output: (Sample)
0: strings: 4
1: Ssct: 26
2: class: 7
3: static: 9
4: String: 26
5: throws: 41
6: System: 6
7: Stosowanie: 26
8: System: 6
9: compile: 24
10: String: 8
11: System: 8
12: start: 31
13: Sample: 14
14: strings: 3
15: simple: 3
16: the: 3
17: Ssct: 3
18: class: 3
19: static: 3
20: String: 3
21: throws: 3
22: System: 3
23: System: 3
24: compile: 4
25: through: 4
26: the: 4
27: the: 4
28: String: 4
29: System: 4
30: start: 4
*///:~
