//: reusing/CADSystem.java
// Wymuszanie poprawnego sprztania.
package reusing;
import static net.mindview.util.Print.*;

class Shape {
  Shape(int i) { print("Konstruktor figury"); }
  void dispose() { print("Usuwanie figury"); }
}

class Circle extends Shape {
  Circle(int i) {
    super(i);
    print("Rysowanie okrgu");
  }
  void dispose() {
    print("Wymazywanie okrgu");
    super.dispose();
  }
}

class Triangle extends Shape {
  Triangle(int i) {
    super(i);
    print("Rysowanie trjkta");
  }
  void dispose() {
    print("Wymazywanie trjkta");
    super.dispose();
  }
}

class Line extends Shape {
  private int start, end;
  Line(int start, int end) {
    super(start);
    this.start = start;
    this.end = end;
    print("Rysowanie linii: " + start + ", " + end);
  }
  void dispose() {
    print("Wymazywanie linii: " + start + ", " + end);
    super.dispose();
  }
}

public class CADSystem extends Shape {
  private Circle c;
  private Triangle t;
  private Line[] lines = new Line[3];
  public CADSystem(int i) {
    super(i + 1);
    for(int j = 0; j < lines.length; j++)
      lines[j] = new Line(j, j*j);
    c = new Circle(1);
    t = new Triangle(1);
    print("Konstruktor czony");
  }
  public void dispose() {
    print("CADSystem.dispose()");
    // Kolejno sprztania jest odwrcona
    // wzgldem kolejnoci inicjalizacji:
    t.dispose();
    c.dispose();
    for(int i = lines.length - 1; i >= 0; i--)
      lines[i].dispose();
    super.dispose();
  }
  public static void main(String[] args) {
    CADSystem x = new CADSystem(47);
    try {
      // Kod i obsuga wyjtkw
    } finally {
      x.dispose();
    }
  }
} /* Output:
Konstruktor figury
Konstruktor figury
Rysowanie linii: 0, 0
Konstruktor figury
Rysowanie linii: 1, 1
Konstruktor figury
Rysowanie linii: 2, 4
Konstruktor figury
Rysowanie okrgu
Konstruktor figury
Rysowanie trjkta
Konstruktor czony
CADSystem.dispose()
Wymazywanie trjkta
Usuwanie figury
Wymazywanie okrgu
Usuwanie figury
Wymazywanie linii: 2, 4
Usuwanie figury
Wymazywanie linii: 1, 1
Usuwanie figury
Wymazywanie linii: 0, 0
Usuwanie figury
Usuwanie figury
*///:~
