//: polymorphism/Frog.java
// Dziedziczenie a sprztanie.
package polymorphism;
import static net.mindview.util.Print.*;

class Characteristic {
  private String s;
  Characteristic(String s) {
    this.s = s;
    print("Tworzenie cechy (Characteristic) " + s);
  }
  protected void dispose() {
    print("Usuwanie cechy (Characteristic) " + s);
  }
}

class Description {
  private String s;
  Description(String s) {
    this.s = s;
    print("Tworzenie opisu (Description) " + s);
  }
  protected void dispose() {
    print("Usuwanie opisu (Description) " + s);
  }
}

class LivingCreature {
  private Characteristic p =
    new Characteristic("yje");
  private Description t =
    new Description("Stworzenie yjce (LivingCreature)");
  LivingCreature() {
    print("LivingCreature()");
  }
  protected void dispose() {
    print("Usuwanie LivingCreature ");
    t.dispose();
    p.dispose();
  }
}

class Animal extends LivingCreature {
  private Characteristic p =
    new Characteristic("ma serce");
  private Description t =
    new Description("Zwierz (Animal), nie rolina");
  Animal() { print("Animal()"); }
  protected void dispose() {
    print("Usuwanie Animal");
    t.dispose();
    p.dispose();
    super.dispose();
  }
}

class Amphibian extends Animal {
  private Characteristic p =
    new Characteristic("moe y w wodzie");
  private Description t =
    new Description("Woda i ldy (Amphibian)");
  Amphibian() {
    print("Amphibian()");
  }
  protected void dispose() {
    print("Usuwanie Amphibian");
    t.dispose();
    p.dispose();
    super.dispose();
  }
}

public class Frog extends Amphibian {
  private Characteristic p = new Characteristic("rechocze");
  private Description t = new Description("owadoerne");
  public Frog() { print("Frog()"); }
  protected void dispose() {
    print("Usuwanie Frog");
    t.dispose();
    p.dispose();
    super.dispose();
  }
  public static void main(String[] args) {
    Frog frog = new Frog();
    print("Pa!");
    frog.dispose();
  }
} /* Output:
Tworzenie cechy (Characteristic) yje
Tworzenie opisu (Description) Stworzenie ywe
LivingCreature()
Tworzenie cechy (Characteristic) ma serce
Tworzenie opisu (Description) Zwierz (Animal), nie rolina
Animal()
Tworzenie cechy (Characteristic) moe y w wodzie
Tworzenie opisu (Description) Woda i ldy
Amphibian()
Tworzenie cechy (Characteristic) rechocze
Tworzenie cechy (Characteristic) owadoerne
Frog()
Pa!
Usuwanie Frog
disposing Description owadoerne
disposing Characteristic rechocze
Usuwanie Amphibian
Usuwanie opisu (Description) Woda i ldy
Usuwanie cechy (Characteristic) moe y w wodzie
Usuwanie Animal
Usuwanie opisu (Description) Zwierz (Animal), nie rolina
Usuwanie cechy (Characteristic) ma serce
Usuwanie LivingCreature
Usuwanie opisu (Description) Stworzenie ywe
Usuwanie cechy (Characteristic) yje
*///:~
