//: net/mindview/util/BasicGenerator.java
// Automatycznie tworzy Generator dla klasy posiadajcej
// konsturktor domylny (bezargumentowy).
package net.mindview.util;

public class BasicGenerator<T> implements Generator<T> {
  private Class<T> type;
  public BasicGenerator(Class<T> type){ this.type = type; }
  public T next() {
    try {
      // Zakadamy, e typ jest klas publiczn:
      return type.newInstance();
    } catch(Exception e) {
      throw new RuntimeException(e);
    }
  }
  // Utworzenie domylnego generatora dla podanego typu:
  public static <T> Generator<T> create(Class<T> type) {
    return new BasicGenerator<T>(type);
  }
} ///:~
