//: io/UsingRandomAccessFile.java
import java.io.*;

public class UsingRandomAccessFile {
  static String file = "rtest.dat";
  static void display() throws IOException {
    RandomAccessFile rf = new RandomAccessFile(file, "r");
    for(int i = 0; i < 7; i++)
      System.out.println(
        "Warto " + i + ": " + rf.readDouble());
    System.out.println(rf.readUTF());
    rf.close();
  }
  public static void main(String[] args)
  throws IOException {
    RandomAccessFile rf = new RandomAccessFile(file, "rw");
    for(int i = 0; i < 7; i++)
      rf.writeDouble(i*1.414);
    rf.writeUTF("Koniec pliku");
    rf.close();
    display();
    rf = new RandomAccessFile(file, "rw");
    rf.seek(5*8);
    rf.writeDouble(47.0001);
    rf.close();
    display();
  }
} /* Output:
Warto 0: 0.0
Warto 1: 1.414
Warto 2: 2.828
Warto 3: 4.242
Warto 4: 5.656
Warto 5: 7.069999999999999
Warto 6: 8.484
Koniec pliku
Warto 0: 0.0
Warto 1: 1.414
Warto 2: 2.828
Warto 3: 4.242
Warto 4: 5.656
Warto 5: 47.0001
Warto 6: 8.484
Koniec pliku
*///:~
