//: io/PreferencesDemo.java
import java.util.prefs.*;
import static net.mindview.util.Print.*;

public class PreferencesDemo {
  public static void main(String[] args) throws Exception {
    Preferences prefs = Preferences
      .userNodeForPackage(PreferencesDemo.class);
    prefs.put("Miejsce akcji", "Oz");
    prefs.put("Obuwie", "czerwone pantofelki");
    prefs.putInt("Kamraci", 4);
    prefs.putBoolean("Jakie wiedmy?", true);
    int usageCount = prefs.getInt("UsageCount", 0);
    usageCount++;
    prefs.putInt("Licznik", usageCount);
    for(String key : prefs.keys())
      print(key + ": "+ prefs.get(key, null));
    // You must always provide a default value:
    print("Ilu towarzyszy podry miaa Dorotka? " +
      prefs.getInt("Kamraci", 0));
  }
} /* Output: (Sample)
Miejsce akcji: Oz
Obuwie: czerwone pantofelki
Kamraci: 4
Jakie wiedmy?: true
Licznik: 53
Ilu towarzyszy podry miaa Dorotka? 4
*///:~
