//: io/Logon.java
// Demonstracja uycia sowa "transient".
import java.util.concurrent.*;
import java.io.*;
import java.util.*;
import static net.mindview.util.Print.*;

public class Logon implements Serializable {
  private Date date = new Date();
  private String username;
  private transient String password;
  public Logon(String name, String pwd) {
    username = name;
    password = pwd;
  }
  public String toString() {
    return "logowanie: \n   uytkownik: " + username +
      "\n   data: " + date + "\n   haso: " + password;
  }
  public static void main(String[] args) throws Exception {
    Logon a = new Logon("Kolos", "TomcioPaluch");
    print("logowanie a = " + a);
    ObjectOutputStream o = new ObjectOutputStream(
      new FileOutputStream("Logon.out"));
    o.writeObject(a);
    o.close();
    TimeUnit.SECONDS.sleep(1); // Opnienie
    // A teraz odtwarzanie:
    ObjectInputStream in = new ObjectInputStream(
      new FileInputStream("Logon.out"));
    print("Odtwarzanie obiektu, czas: " + new Date());
    a = (Logon)in.readObject();
    print("logowanie a = " + a);
  }
} /* Output: (Sample)
logowanie a = logowanie: 
   uytkownik: Kolos
   data: Fri Mar 17 11:59:13 CET 2006
   haso: TomcioPaluch
Odtwarzanie obiektu, czas: Fri Mar 17 11:59:14 CET 2006
logowanie a = logowanie: 
   uytkownik: Kolos
   data: Fri Mar 17 11:59:13 CET 2006
   haso: null
*///:~
