//: io/GetChannel.java
// Wyuskiwanie kanaw ze strumieni
import java.nio.*;
import java.nio.channels.*;
import java.io.*;

public class GetChannel {
  private static final int BSIZE = 1024;
  public static void main(String[] args) throws Exception {
    // Zapis do pliku:
    FileChannel fc =
      new FileOutputStream("data.txt").getChannel();
    fc.write(ByteBuffer.wrap("Porcja danych ".getBytes()));
    fc.close();
    // DOdanie danych na koniec pliku:
    fc =
      new RandomAccessFile("data.txt", "rw").getChannel();
    fc.position(fc.size()); // Przesunicie na koniec pliku
    fc.write(ByteBuffer.wrap("Jeszcze odrobina".getBytes()));
    fc.close();
    // Wczytanie pliku:
    fc = new FileInputStream("data.txt").getChannel();
    ByteBuffer buff = ByteBuffer.allocate(BSIZE);
    fc.read(buff);
    buff.flip();
    while(buff.hasRemaining())
      System.out.print((char)buff.get());
  }
} /* Output:
Porcja danych Jeszcze odrobina
*///:~
