//: io/DirectoryDemo.java
// Prbka moliwoci klasy Directory.
import java.io.*;
import net.mindview.util.*;
import static net.mindview.util.Print.*;

public class DirectoryDemo {
  public static void main(String[] args) {
    // Wszystkie katalogi:
    PPrint.pprint(Directory.walk(".").dirs);
    // Wszystkie pliki o nazwach zaczynajcych si od 'T'
    for(File file : Directory.local(".", "T.*"))
      print(file);
    print("----------------------");
    // Wszystkie pliki rdowe jzyka Java zaczynajce si na 'T':
    for(File file : Directory.walk(".", "T.*\\.java"))
      print(file);
    print("======================");
    // Pliki klas zawierajce w nazwie 'Z' bd 'z':
    for(File file : Directory.walk(".",".*[Zz].*\\.class"))
      print(file);
  }
} /* Output: (Sample)
[.\xfiles]
.\TestEOF.class
.\TestEOF.java
.\TransferTo.class
.\TransferTo.java
----------------------
.\TestEOF.java
.\TransferTo.java
.\xfiles\ThawAlien.java
======================
.\FreezeAlien.class
.\GZIPcompress.class
.\ZipCompress.class
*///:~
