//: innerclasses/LocalInnerClass.java
// Przechowuje sekwencj obiektw klasy Object.
import static net.mindview.util.Print.*;

interface Counter {
  int next();
}	

public class LocalInnerClass {
  private int count = 0;
  Counter getCounter(final String name) {
    // Lokalna klasa wewntrzna:
    class LocalCounter implements Counter {
      public LocalCounter() {
        // Lokalna klasa wewntrzna moe mie konstruktor
        print("LocalCounter()");
      }
      public int next() {
        printnb(name); // Dostp do lokalnego pola finalnego
        return count++;
      }
    }
    return new LocalCounter();
  }	
  // Analogicznie w anonimowych klasach wewntrznych:
  Counter getCounter2(final String name) {
    return new Counter() {
      // Anonimowa klasa wewntrzna nie moe posiada nazwanego
      // konstruktora, jedynie blok inicjalizacji egzemplarza
      {
        print("Counter()");
      }
      public int next() {
        printnb(name); // Dostp do lokalnego pola finalnego
        return count++;
      }
    };
  }	
  public static void main(String[] args) {
    LocalInnerClass lic = new LocalInnerClass();
    Counter
      c1 = lic.getCounter("Lokalny obiekt wewntrzny "),
      c2 = lic.getCounter2("Anonimowy obiekt wewntrzny ");
    for(int i = 0; i < 5; i++)
      print(c1.next());
    for(int i = 0; i < 5; i++)
      print(c2.next());
  }
} /* Output:
LocalCounter()
Counter()
Lokalny obiekt wewntrzny 0
Lokalny obiekt wewntrzny 1
Lokalny obiekt wewntrzny 2
Lokalny obiekt wewntrzny 3
Lokalny obiekt wewntrzny 4
Anonimowy obiekt wewntrzny 5
Anonimowy obiekt wewntrzny 6
Anonimowy obiekt wewntrzny 7
Anonimowy obiekt wewntrzny 8
Anonimowy obiekt wewntrzny 9
*///:~
