//: innerclasses/GreenhouseController.java
// Konfiguracja i uruchomienie systemu osugi szklarni.
// {Args: 5000}
import innerclasses.controller.*;

public class GreenhouseController {
  public static void main(String[] args) {
    GreenhouseControls gc = new GreenhouseControls();
    // Zamiast sztywnego konfigurowania komponentw moemy
    // tu wczyta parametry startowe z pliku tekstowego:
    gc.addEvent(gc.new Bell(900));
    Event[] eventList = {
      gc.new ThermostatNight(0),
      gc.new LightOn(200),
      gc.new LightOff(400),
      gc.new WaterOn(600),
      gc.new WaterOff(800),
      gc.new ThermostatDay(1400)
    };	
    gc.addEvent(gc.new Restart(2000, eventList));
    if(args.length == 1)
      gc.addEvent(
        new GreenhouseControls.Terminate(
          new Integer(args[0])));
    gc.run();
  }
} /* Output:
Dzy!
Termostat przeczony na ustawienie nocne
wiata wczone
wiata wyczone
Obieg wody w szklarni wczony
Obieg wody w szklarni wyczony
Termostat przeczony na ustawienie dzienne
Restart systemu
Koniec
*///:~
