//: innerclasses/Callbacks.java
// Klasy wewntrzne w wywoaniach zwrotnych
package innerclasses;
import static net.mindview.util.Print.*;

interface Incrementable {
  void increment();
}

// Uproszczona klasa implementacji interfejsu:
class Callee1 implements Incrementable {
  private int i = 0;
  public void increment() {
    i++;
    print(i);
  }
}	

class MyIncrement {
  public void increment() { print("Inna operacja"); }
  static void f(MyIncrement mi) { mi.increment(); }
}	

// Jeli dana klasa musi jako inaczej implementowa
// metod increment(), naley uy klasy wewntrznej:
class Callee2 extends MyIncrement {
  private int i = 0;
  public void increment() {
    super.increment();
    i++;
    print(i);
  }
  private class Closure implements Incrementable {
    public void increment() {
      // Okrelenie metody zewntrznej, zapobiegajce
      // nieskoczonej rekurencji wywoa:
      Callee2.this.increment();
    }
  }
  Incrementable getCallbackReference() {
    return new Closure();
  }
}	

class Caller {
  private Incrementable callbackReference;
  Caller(Incrementable cbh) { callbackReference = cbh; }
  void go() { callbackReference.increment(); }
}

public class Callbacks {
  public static void main(String[] args) {
    Callee1 c1 = new Callee1();
    Callee2 c2 = new Callee2();
    MyIncrement.f(c2);
    Caller caller1 = new Caller(c1);
    Caller caller2 = new Caller(c2.getCallbackReference());
    caller1.go();
    caller1.go();
    caller2.go();
    caller2.go();
  }	
} /* Output:
Inna operacja
1
1
2
Inna operacja
2
Inna operacja
3
*///:~
