//: initialization/OrderOfInitialization.java
// Demonstruje kolejno inicjalizacji.
import static net.mindview.util.Print.*;

// Kiedy do utworzenia obiektu Window wywoywany jest konstruktor,
// program wypisuje komunikat na wyjciu:
class Window {
  Window(int marker) { print("Window(" + marker + ")"); }
}

class House {
  Window w1 = new Window(1); // Przed konstruktorem
  House() {
    // Pokamy, e jestemy w konstruktoreze:
    print("House()");
    w3 = new Window(33); // Ponowna inicjalizacja w3
  }
  Window w2 = new Window(2); // Za konstruktorem
  void f() { print("f()"); }
  Window w3 = new Window(3); // Na kocu
}

public class OrderOfInitialization {
  public static void main(String[] args) {
    House h = new House();
    h.f(); // Pokazuje, e konstrukcja si odbya
  }
} /* Output:
Window(1)
Window(2)
Window(3)
House()
Window(33)
f()
*///:~
