//: initialization/Mugs.java
// "Inicjalizacja egzemplarzy niestatycznych"
import static net.mindview.util.Print.*;

class Mug {
  Mug(int marker) {
    print("Mug(" + marker + ")");
  }
  void f(int marker) {
    print("f(" + marker + ")");
  }
}

public class Mugs {
  Mug mug1;
  Mug mug2;
  {
    mug1 = new Mug(1);
    mug2 = new Mug(2);
    print("Zainicjalizowano mug1 i mug2");
  }
  Mugs() {
    print("Mugs()");
  }
  Mugs(int i) {
    print("Mugs(int)");
  }
  public static void main(String[] args) {
    print("Wewntrz main()");
    new Mugs();
    print("new Mugs() - zakoczone");
    new Mugs(1);
    print("new Mugs(1) - zakoczone");
  }
} /* Output:
Wewntrz main()
Mug(1)
Mug(2)
Zainicjalizowano mug1 i mug2
Mugs()
new Mugs() - zakoczone
Mug(1)
Mug(2)
Zainicjalizowano mug1 i mug2
Mugs(int)
new Mugs(1) - zakoczone
*///:~
