//: gui/Menus.java
// Menu kaskadowe, pola wyboru w menu, podmienianie
// pozycji menu, skrty klawiaturowe i polecenia akcji.
import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import static net.mindview.util.SwingConsole.*;

public class Menus extends JFrame {
  private String[] flavors = {
    "Czekoladowe", "Truskawkowe", "Waniliowe",
    "Mitowe", "Mocca", "Rumowe",
    "Karmelowe", "Bakaliowe"
  };
  private JTextField t = new JTextField("Brak smaku", 30);
  private JMenuBar mb1 = new JMenuBar();
  private JMenu
    f = new JMenu("Plik"),
    m = new JMenu("Smaki"),
    s = new JMenu("Bezpieczestwo");
  // Albo tak:
  private JCheckBoxMenuItem[] safety = {
    new JCheckBoxMenuItem("Chro"),
    new JCheckBoxMenuItem("Ukryj")
  };
  private JMenuItem[] file = { new JMenuItem("Otwrz") };
  // Podmiana drugiego paska menu:
  private JMenuBar mb2 = new JMenuBar();
  private JMenu fooBar = new JMenu("blaBla");
  private JMenuItem[] other = {
    // Dodawanie skrtu klawiaturowego jest bardzo proste
    // ale mona go doda do pozycji menu (JMenuItem) tylko
    // w konstruktorze pozycji:
    new JMenuItem("Ble", KeyEvent.VK_F),
    new JMenuItem("Bla", KeyEvent.VK_A),
    // Bez skrtu klawiaturowego:
    new JMenuItem("Ple"),
  };
  private JButton b = new JButton("Wymiana Menu");
  class BL implements ActionListener {
    public void actionPerformed(ActionEvent e) {
      JMenuBar m = getJMenuBar();
      setJMenuBar(m == mb1 ? mb2 : mb1);
      validate(); // Odwieenie ramki
    }
  }
  class ML implements ActionListener {
    public void actionPerformed(ActionEvent e) {
      JMenuItem target = (JMenuItem)e.getSource();
      String actionCommand = target.getActionCommand();
      if(actionCommand.equals("Otwrz")) {
        String s = t.getText();
        boolean chosen = false;
        for(String flavor : flavors)
          if(s.equals(flavor))
            chosen = true;
        if(!chosen)
          t.setText("Najpierw wybierz smak!");
        else
          t.setText("Otwieram " + s + ". Mmm, mm!");
      }
    }
  }
  class FL implements ActionListener {
    public void actionPerformed(ActionEvent e) {
      JMenuItem target = (JMenuItem)e.getSource();
      t.setText(target.getText());
    }
  }
  // Alternatywnie mona utworzy oddzieln klas dla kadego
  // osobnego elementu MenuItem. Potem nie trzeba si przejmowa
  // ich rozrnianiem:
  class FooL implements ActionListener {
    public void actionPerformed(ActionEvent e) {
      t.setText("Wybrano Ble");
    }
  }
  class BarL implements ActionListener {
    public void actionPerformed(ActionEvent e) {
      t.setText("Wybrano Bla");
    }
  }
  class BazL implements ActionListener {
    public void actionPerformed(ActionEvent e) {
      t.setText("Wybrano Ple");
    }
  }
  class CMIL implements ItemListener {
    public void itemStateChanged(ItemEvent e) {
      JCheckBoxMenuItem target =
        (JCheckBoxMenuItem)e.getSource();
      String actionCommand = target.getActionCommand();
      if(actionCommand.equals("Chro"))
        t.setText("Chroni lody! " +
          "Ochrona " + target.getState());
      else if(actionCommand.equals("Ukryj"))
        t.setText("Schowa lody! " +
          "Schowane? " + target.getState());
    }
  }
  public Menus() {
    ML ml = new ML();
    CMIL cmil = new CMIL();
    safety[0].setActionCommand("Chro");
    safety[0].setMnemonic(KeyEvent.VK_G);
    safety[0].addItemListener(cmil);
    safety[1].setActionCommand("Ukryj");
    safety[1].setMnemonic(KeyEvent.VK_H);
    safety[1].addItemListener(cmil);
    other[0].addActionListener(new FooL());
    other[1].addActionListener(new BarL());
    other[2].addActionListener(new BazL());
    FL fl = new FL();
    int n = 0;
    for(String flavor : flavors) {
      JMenuItem mi = new JMenuItem(flavor);
      mi.addActionListener(fl);
      m.add(mi);
      // Dodanie separatorw:
      if((n++ + 1) % 3 == 0)
        m.addSeparator();
    }
    for(JCheckBoxMenuItem sfty : safety)
      s.add(sfty);
    s.setMnemonic(KeyEvent.VK_A);
    f.add(s);
    f.setMnemonic(KeyEvent.VK_F);
    for(int i = 0; i < file.length; i++) {
      file[i].addActionListener(ml);
      f.add(file[i]);
    }
    mb1.add(f);
    mb1.add(m);
    setJMenuBar(mb1);
    t.setEditable(false);
    add(t, BorderLayout.CENTER);
    // Przygotowanie do podmiany menu:
    b.addActionListener(new BL());
    b.setMnemonic(KeyEvent.VK_S);
    add(b, BorderLayout.NORTH);
    for(JMenuItem oth : other)
      fooBar.add(oth);
    fooBar.setMnemonic(KeyEvent.VK_B);
    mb2.add(fooBar);
  }
  public static void main(String[] args) {
    run(new Menus(), 300, 200);
  }
} ///:~
