//: generics/LatentReflection.java
// Zastosowanie refleksji do uzyskania typowania utajonego.
import java.lang.reflect.*;
import static net.mindview.util.Print.*;

// Nie implementuje interfejsu Performs:
class Mime {
  public void walkAgainstTheWind() {}
  public void sit() { print("Udaje, e siada"); }
  public void pushInvisibleWalls() {}
  public String toString() { return "Mim"; }
}

// Nie implementuje interfejsu Performs:
class SmartDog {
  public void speak() { print("Hau!"); }
  public void sit() { print("Siada"); }
  public void reproduce() {}
}	

class CommunicateReflectively {
  public static void perform(Object speaker) {
    Class<?> spkr = speaker.getClass();
    try {
      try {
        Method speak = spkr.getMethod("speak");
        speak.invoke(speaker);
      } catch(NoSuchMethodException e) {
        print(speaker + " nie potrafi da gosu");
      }
      try {
        Method sit = spkr.getMethod("sit");
        sit.invoke(speaker);
      } catch(NoSuchMethodException e) {
        print(speaker + " nie potrafi usi");
      }
    } catch(Exception e) {
      throw new RuntimeException(speaker.toString(), e);
    }
  }
}

public class LatentReflection {
  public static void main(String[] args) {
    CommunicateReflectively.perform(new SmartDog());
    CommunicateReflectively.perform(new Robot());
    CommunicateReflectively.perform(new Mime());
  }
} /* Output:
Hau!
Siada
Klik!
Zgrrt!
Mim nie potrafi da gosu
Udaje, e siada
*///:~
