//: generics/InstantiateGenericType.java
import static net.mindview.util.Print.*;

class ClassAsFactory<T> {
  T x;
  public ClassAsFactory(Class<T> kind) {
    try {
      x = kind.newInstance();
    } catch(Exception e) {
      throw new RuntimeException(e);
    }
  }
}

class Employee {}	

public class InstantiateGenericType {
  public static void main(String[] args) {
    ClassAsFactory<Employee> fe =
      new ClassAsFactory<Employee>(Employee.class);
    print("Udao si utworzy obiekt ClassAsFactory<Employee>");
    try {
      ClassAsFactory<Integer> fi =
        new ClassAsFactory<Integer>(Integer.class);
    } catch(Exception e) {
      print("Nie udao si utworzy obiektu ClassAsFactory<Integer>");
    }
  }
} /* Output:
Udao si utworzy obiekt ClassAsFactory<Employee>
Nie udao si utworzy obiektu ClassAsFactory<Integer>
*///:~
