//: generics/CovariantArrays.java

class Fruit {}
class Apple extends Fruit {}
class Jonathan extends Apple {}
class Orange extends Fruit {}

public class CovariantArrays {
  public static void main(String[] args) {
    Fruit[] fruit = new Apple[10];
    fruit[0] = new Apple(); // OK
    fruit[1] = new Jonathan(); // OK
    // Typ w czasie wykonania to Apple[], nie Fruit[] ani Orange[]:
    try {
      // Kompilator pozwoli na dodanie egzemplarza Fruit:
      fruit[0] = new Fruit(); // Wyjtek ArrayStoreException
    } catch(Exception e) { System.out.println(e); }
    try {
      // Kompilator pozwoli na dodanie egzemplarzy Orange:
      fruit[0] = new Orange(); // Wyjtek ArrayStoreException
    } catch(Exception e) { System.out.println(e); }
  }
} /* Output:
java.lang.ArrayStoreException: Fruit
java.lang.ArrayStoreException: Orange
*///:~
