//: exceptions/TurnOffChecking.java
// "Wyczanie" wyjtkw sprawdzanych.
import java.io.*;
import static net.mindview.util.Print.*;

class WrapCheckedException {
  void throwRuntimeException(int type) {
    try {
      switch(type) {
        case 0: throw new FileNotFoundException();
        case 1: throw new IOException();
        case 2: throw new RuntimeException("Gdzie jestem?");
        default: return;
      }
    } catch(Exception e) { // Adaptacja do wyjtku niesprawdzanego:
      throw new RuntimeException(e);
    }
  }
}

class SomeOtherException extends Exception {}

public class TurnOffChecking {
  public static void main(String[] args) {
    WrapCheckedException wce = new WrapCheckedException();
    // Metod throwRuntimeException() mona wywoa bez bloku try
    // i pozwoli na opuszczenie metody przez wyjtek RuntimeException:
    wce.throwRuntimeException(3);
    // Albo przechwyci wyjtki:
    for(int i = 0; i < 4; i++)
      try {
        if(i < 3)
          wce.throwRuntimeException(i);
        else
          throw new SomeOtherException();
      } catch(SomeOtherException e) {
          print("SomeOtherException: " + e);
      } catch(RuntimeException re) {
        try {
          throw re.getCause();
        } catch(FileNotFoundException e) {
          print("FileNotFoundException: " + e);
        } catch(IOException e) {
          print("IOException: " + e);
        } catch(Throwable e) {
          print("Throwable: " + e);
        }
      }
  }
} /* Output:
FileNotFoundException: java.io.FileNotFoundException
IOException: java.io.IOException
Throwable: java.lang.RuntimeException: Gdzie jestem?
SomeOtherException: SomeOtherException
*///:~
