//: exceptions/StormyInning.java
// Metody przesonite mog wyrzuca jedynie te wyjtki,
// ktre zostay okrelone w wersjach z klasy bazowej,
// ewentualnie pochodne wyjtkw tam okrelonych.

class BaseballException extends Exception {}
class Foul extends BaseballException {}
class Strike extends BaseballException {}

abstract class Inning {
  public Inning() throws BaseballException {}
  public void event() throws BaseballException {
    // Nie musi niczego wyrzuca
  }
  public abstract void atBat() throws Strike, Foul;
  public void walk() {} // Nie wyrzuca sprawdzanych wyjtkw
}

class StormException extends Exception {}
class RainedOut extends StormException {}
class PopFoul extends Foul {}

interface Storm {
  public void event() throws RainedOut;
  public void rainHard() throws RainedOut;
}

public class StormyInning extends Inning implements Storm {
  // Mona dodawa nowe wyjtki dla konstruktorw, ale trzeba
  // poradzi sobie z wyjtkami konstruktora klasy bazowej:
  public StormyInning()
    throws RainedOut, BaseballException {}
  public StormyInning(String s)
    throws Foul, BaseballException {}
  // Zwyke metody musz trzyma si specyfikacji wyjtkw
  // wedug wersjiz klasy bazowej:
//! void walk() throws PopFoul {} // Bd kompilacji
  // Interfejs NIE MOE dodawa wyjtkw do istniejcych
  // metod klasy bazowej:
//! public void event() throws RainedOut {}
  // Jeli metoda nie istnieje w klasie bazowej,
  // mona jej nada dowoln specyfikacj wyjtkw
  public void rainHard() throws RainedOut {}
  // Mona zaniecha wyrzucania jakichkolwiek wyjtkw
  // pomimo ich obecnoci w klasie bazowej:
  public void event() {}
  // Metody przesonite mog wyrzuca wyjtki pochodne
  public void atBat() throws PopFoul {}
  public static void main(String[] args) {
    try {
      StormyInning si = new StormyInning();
      si.atBat();
    } catch(PopFoul e) {
      System.out.println("Pop foul");
    } catch(RainedOut e) {
      System.out.println("Rained out");
    } catch(BaseballException e) {
      System.out.println("Oglny wyjtek rozgrywki");
    }
    // Wyjtek Strike nie jest zgaszany w wersji przecionej.
    try {
      // Co si stanie przy rzutowaniu w gr?
      Inning i = new StormyInning();
      i.atBat();
      // Trzeba przechwyci wyjtki z wersji metody
      // z klasy bazowej
    } catch(Strike e) {
      System.out.println("Strike");
    } catch(Foul e) {
      System.out.println("Foul");
    } catch(RainedOut e) {
      System.out.println("Rained out");
    } catch(BaseballException e) {
      System.out.println("Oglny wyjtek rozgrywki");
    }
  }
} ///:~
