//: exceptions/ExtraFeatures.java
// Dalsze polerowanie wasnych klas wyjtkw.
import static net.mindview.util.Print.*;

class MyException2 extends Exception {
  private int x;
  public MyException2() {}
  public MyException2(String msg) { super(msg); }
  public MyException2(String msg, int x) {
    super(msg);
    this.x = x;
  }
  public int val() { return x; }
  public String getMessage() {
    return "Komunikat szczegowy: "+ x + " "+ super.getMessage();
  }
}

public class ExtraFeatures {
  public static void f() throws MyException2 {
    print("Wyrzucam wyjtek MyException2 z f()");
    throw new MyException2();
  }
  public static void g() throws MyException2 {
    print("Wyrzucam wyjtek MyException2 z g()");
    throw new MyException2("Poczty w g()");
  }
  public static void h() throws MyException2 {
    print("Wyrzucam wyjtek MyException2 from h()");
    throw new MyException2("Poczty w h()", 47);
  }
  public static void main(String[] args) {
    try {
      f();
    } catch(MyException2 e) {
      e.printStackTrace(System.out);
    }
    try {
      g();
    } catch(MyException2 e) {
      e.printStackTrace(System.out);
    }
    try {
      h();
    } catch(MyException2 e) {
      e.printStackTrace(System.out);
      System.out.println("e.val() = " + e.val());
    }
  }
} /* Output:
Wyrzucam wyjtek MyException2 z f()
MyException2: Detail Message: 0 null
        at ExtraFeatures.f(ExtraFeatures.java:22)
        at ExtraFeatures.main(ExtraFeatures.java:34)
Wyrzucam wyjtek MyException2 z g()
MyException2: Detail Message: 0 Poczty w g()
        at ExtraFeatures.g(ExtraFeatures.java:26)
        at ExtraFeatures.main(ExtraFeatures.java:39)
Wyrzucam wyjtek MyException2 z h()
MyException2: Detail Message: 47 Poczty w h()
        at ExtraFeatures.h(ExtraFeatures.java:30)
        at ExtraFeatures.main(ExtraFeatures.java:44)
e.val() = 47
*///:~
