//: enumerated/cartoons/EnumImplementation.java
// Typ wyliczeniowy moe implementowa interfejsy
package enumerated.cartoons;
import java.util.*;
import net.mindview.util.*;

enum CartoonCharacter
implements Generator<CartoonCharacter> {
  REKSIO, BOLEK, LOLEK, TOLA, WILK, ZAJC, BOB;
  private Random rand = new Random(47);
  public CartoonCharacter next() {
    return values()[rand.nextInt(values().length)];
  }
}

public class EnumImplementation {
  public static <T> void printNext(Generator<T> rg) {
    System.out.print(rg.next() + ", ");
  }
  public static void main(String[] args) {
    // Wybierz dowoln nazw:
    CartoonCharacter cc = CartoonCharacter.BOB;
    for(int i = 0; i < 10; i++)
      printNext(cc);
  }
} /* Output:
BOB, LOLEK, BOB, BOLEK, ZAJC, LOLEK, REKSIO, ZAJC, ZAJ, REKSIO,
*///:~
