//: enumerated/RoShamBo6.java
// Wyliczenia z "tabelami" zamiast wielokrotnego rozprowadzania
package enumerated;
import static enumerated.Outcome.*;

enum RoShamBo6 implements Competitor<RoShamBo6> {
  PAPER {
    public String toString() { return "Papier"; }
  },
  SCISSORS {
    public String toString() { return "Noyczki"; }
  },
  ROCK {
    public String toString() { return "Kamie"; }
  };
  private static Outcome[][] table = {
    { DRAW, LOSE, WIN }, // Papier
    { WIN, DRAW, LOSE }, // Noyczki
    { LOSE, WIN, DRAW }, // Kamie
  };
  public Outcome compete(RoShamBo6 other) {
    return table[this.ordinal()][other.ordinal()];
  }
  public static void main(String[] args) {
    RoShamBo.play(RoShamBo6.class, 20);
  }
} ///:~
