//: enumerated/PostOffice.java
// Modelowanie urzdu pocztowego.
import java.util.*;
import net.mindview.util.*;
import static net.mindview.util.Print.*;

class Mail {
  // Wartoci NO obniaj prawdopodobiestwo przy losowym wyborze:
  enum GeneralDelivery {YES,NO1,NO2,NO3,NO4,NO5}
  enum Scannability {UNSCANNABLE,YES1,YES2,YES3,YES4}
  enum Readability {ILLEGIBLE,YES1,YES2,YES3,YES4}
  enum Address {INCORRECT,OK1,OK2,OK3,OK4,OK5,OK6}
  enum ReturnAddress {MISSING,OK1,OK2,OK3,OK4,OK5}
  GeneralDelivery generalDelivery;
  Scannability scannability;
  Readability readability;
  Address address;
  ReturnAddress returnAddress;
  static long counter = 0;
  long id = counter++;
  public String toString() { return "Przesyka " + id; }
  public String details() {
    return toString() +
      ", Poste restante: " + generalDelivery +
      ", Zdatno do czytnika: " + scannability +
      ", Czytelno adresu: " + readability +
      ", Adres: " + address +
      ", Adres zwrotny: " + returnAddress;
  }
  // Generowanie przesyek testowych:
  public static Mail randomMail() {
    Mail m = new Mail();
    m.generalDelivery= Enums.random(GeneralDelivery.class);
    m.scannability = Enums.random(Scannability.class);
    m.readability = Enums.random(Readability.class);
    m.address = Enums.random(Address.class);
    m.returnAddress = Enums.random(ReturnAddress.class);
    return m;
  }
  public static Iterable<Mail> generator(final int count) {
    return new Iterable<Mail>() {
      int n = count;
      public Iterator<Mail> iterator() {
        return new Iterator<Mail>() {
          public boolean hasNext() { return n-- > 0; }
          public Mail next() { return randomMail(); }
          public void remove() { // Bez implementacji
            throw new UnsupportedOperationException();
          }
        };
      }
    };
  }
}

public class PostOffice {
  enum MailHandler {
    GENERAL_DELIVERY {
      boolean handle(Mail m) {
        switch(m.generalDelivery) {
          case YES:
            print(m + " - poste restante");
            return true;
          default: return false;
        }
      }
    },
    MACHINE_SCAN {
      boolean handle(Mail m) {
        switch(m.scannability) {
          case UNSCANNABLE: return false;
          default:
            switch(m.address) {
              case INCORRECT: return false;
              default:
                print(m + " - obsuga przez automat");
                return true;
            }
        }
      }
    },
    VISUAL_INSPECTION {
      boolean handle(Mail m) {
        switch(m.readability) {
          case ILLEGIBLE: return false;
          default:
            switch(m.address) {
              case INCORRECT: return false;
              default:
                print(m + " - obsuga rczna");
                return true;
            }
        }
      }
    },
    RETURN_TO_SENDER {
      boolean handle(Mail m) {
        switch(m.returnAddress) {
          case MISSING: return false;
          default:
            print(m + " - zwrot do nadawcy");
            return true;
        }
      }
    };
    abstract boolean handle(Mail m);
  }
  static void handle(Mail m) {
    for(MailHandler handler : MailHandler.values())
      if(handler.handle(m))
        return;
    print(m + " - przesyka martwa");
  }
  public static void main(String[] args) {
    for(Mail mail : Mail.generator(10)) {
      print(mail.details());
      handle(mail);
      print("*****");
    }
  }
} /* Output:
Przesyka 0, Poste restante: NO2, Zdatno do czytnika: UNSCANNABLE, Czytelno adresu: YES3, Adres: OK1, Adres zwrotny: OK1
Przesyka 0 - obsuga rczna
*****
Przesyka 1, Poste restante: NO5, Zdatno do czytnika: YES3, Czytelno adresu: ILLEGIBLE, Adres: OK5, Adres zwrotny: OK1
Przesyka 1 - obsuga przez automat
*****
Przesyka 2, Poste restante: YES, Zdatno do czytnika: YES3, Czytelno adresu: YES1, Adres: OK1, Adres zwrotny: OK5
Przesyka 2 - poste restante
*****
Przesyka 3, Poste restante: NO4, Zdatno do czytnika: YES3, Czytelno adresu: YES1, Adres: INCORRECT, Adres zwrotny: OK4
Przesyka 3 - zwrot do nadawcy
*****
Przesyka 4, Poste restante: NO4, Zdatno do czytnika: UNSCANNABLE, Czytelno adresu: YES1, Adres: INCORRECT, Adres zwrotny: OK2
Przesyka 4 - zwrot do nadawcy
*****
Przesyka 5, Poste restante: NO3, Zdatno do czytnika: YES1, Czytelno adresu: ILLEGIBLE, Adres: OK4, Adres zwrotny: OK2
Przesyka 5 - obsuga przez automat
*****
Przesyka 6, Poste restante: YES, Zdatno do czytnika: YES4, Czytelno adresu: ILLEGIBLE, Adres: OK4, Adres zwrotny: OK4
Przesyka 6 - poste restante
*****
Przesyka 7, Poste restante: YES, Zdatno do czytnika: YES3, Czytelno adresu: YES4, Adres: OK2, Adres zwrotny: MISSING
Przesyka 7 - poste restante
*****
Przesyka 8, Poste restante: NO3, Zdatno do czytnika: YES1, Czytelno adresu: YES3, Adres: INCORRECT, Adres zwrotny: MISSING
Przesyka 8 - przesyka martwa
*****
Przesyka 9, Poste restante: NO1, Zdatno do czytnika: UNSCANNABLE, Czytelno adresu: YES2, Adres: OK1, Adres zwrotny: OK4
Przesyka 9 - obsuga rczna
*****
*///:~
