//: containers/Utilities.java
// Demonstracja oprzyrzdowania z klasy Collections.
import java.util.*;
import static net.mindview.util.Print.*;

public class Utilities {
  static List<String> list = Arrays.asList(
    "jeden Dwa trzy Cztery pi sze jeden".split(" "));
  public static void main(String[] args) {
    print(list);
    print("Rozczno list (Cztery)?: " +
      Collections.disjoint(list,
        Collections.singletonList("Cztery")));
    print("max: " + Collections.max(list));
    print("min: " + Collections.min(list));
    print("max z komparatorem: " + Collections.max(list,
      String.CASE_INSENSITIVE_ORDER));
    print("min z komparatorem: " + Collections.min(list,
      String.CASE_INSENSITIVE_ORDER));
    List<String> sublist =
      Arrays.asList("Cztery pi sze".split(" "));
    print("indexOfSubList: " +
      Collections.indexOfSubList(list, sublist));
    print("lastIndexOfSubList: " +
      Collections.lastIndexOfSubList(list, sublist));
    Collections.replaceAll(list, "jeden", "Uj");
    print("replaceAll: " + list);
    Collections.reverse(list);
    print("reverse: " + list);
    Collections.rotate(list, 3);
    print("rotate: " + list);
    List<String> source =
      Arrays.asList("we wntrzu macierzy".split(" "));
    Collections.copy(list, source);
    print("copy: " + list);
    Collections.swap(list, 0, list.size() - 1);
    print("swap: " + list);
    Collections.shuffle(list, new Random(47));
    print("shuffle: " + list);
    Collections.fill(list, "pop");
    print("fill: " + list);
    print("czstotliwo sowa 'pop': " +
      Collections.frequency(list, "pop"));
    List<String> dups = Collections.nCopies(3, "pstryk");
    print("duplikaty: " + dups);
    print("rozczno list ('duplikaty')?: " +
      Collections.disjoint(list, dups));
    // Pozyskiwanie enumeratora:
    Enumeration<String> e = Collections.enumeration(dups);
    Vector<String> v = new Vector<String>();
    while(e.hasMoreElements())
      v.addElement(e.nextElement());
    // Konwersja kontenera Vector
    // na list List za pomoc enumeratora:
    ArrayList<String> arrayList =
      Collections.list(v.elements());
    print("arrayList: " + arrayList);
  }
} /* Output:
[jeden, Dwa, trzy, Cztery, pi, sze, jeden]
Rozczno list (Cztery)?: false
max: trzy
min: Cztery
max z komparatorem: trzy
min z komparatorem: Cztery
indexOfSubList: 3
lastIndexOfSubList: 3
replaceAll: [Uj, Dwa, trzy, Cztery, pi, sze, Uj]
reverse: [Uj, sze, pi, Cztery, trzy, Dwa, Uj]
rotate: [trzy, Dwa, Uj, Uj, sze, pi, Cztery]
copy: [we, wntrzu, macierzy, Uj, sze, pi, Cztery]
swap: [Cztery, wntrzu, macierzy, Uj, sze, pi, we]
shuffle: [sze, macierzy, wntrzu, Cztery, Uj, pi, we]
fill: [pop, pop, pop, pop, pop, pop, pop]
czstotliwo sowa 'pop': 7
duplikaty: [pstryk, pstryk, pstryk]
rozczno list ('duplikaty')?: true
arrayList: [pstryk, pstryk, pstryk]
*///:~
