//: containers/SpringDetector.java
// Jaka bdzie pogoda?
import java.lang.reflect.*;
import java.util.*;
import static net.mindview.util.Print.*;

public class SpringDetector {
  // Uywa klasy Groundhog albo klasy pochodnej:
  public static <T extends Groundhog>
  void detectSpring(Class<T> type) throws Exception {
    Constructor<T> ghog = type.getConstructor(int.class);
    Map<Groundhog,Prediction> map =
      new HashMap<Groundhog,Prediction>();
    for(int i = 0; i < 10; i++)
      map.put(ghog.newInstance(i), new Prediction());
    print("odwzorowanie = " + map);
    Groundhog gh = ghog.newInstance(3);
    print("Szukanie prognozy dla " + gh);
    if(map.containsKey(gh))
      print(map.get(gh));
    else
      print("Brak klucza: " + gh);
  }
  public static void main(String[] args) throws Exception {
    detectSpring(Groundhog.class);
  }
} /* Output:
odwzorowanie = {Groundhog nr 2=Wczesna wiosna!, Groundhog nr 5=Wczesna wiosna!, Groundhog nr 4=Jeszcze sze miesicy zimy!, Groundhog nr 7=Wczesna wiosna!, Groundhog nr 1=Jeszcze sze miesicy zimy!, Groundhog nr 8=Jeszcze sze miesicy zimy!, Groundhog nr 3=Wczesna wiosna!, Groundhog nr 0=Jeszcze sze miesicy zimy!, Groundhog nr 9=Jeszcze sze miesicy zimy!, Groundhog nr 6=Wczesna wiosna!}
Szukanie prognozy dla Groundhog nr 3
Brak klucza: Groundhog nr 3
*///:~
