//: containers/CountedString.java
// Dobra funkcja haszujca hashCode().
import java.util.*;
import static net.mindview.util.Print.*;

public class CountedString {
  private static List<String> created =
    new ArrayList<String>();
  private String s;
  private int id = 0;
  public CountedString(String str) {
    s = str;
    created.add(s);
    // id to czna liczba egzemplarzy
    // cigu w uyciu CountedString:
    for(String s2 : created)
      if(s2.equals(s))
        id++;
  }
  public String toString() {
    return "Cig: " + s + " id: " + id +
      " hashCode(): " + hashCode();
  }
  public int hashCode() {
    // Wersja uproszczona:
    // return s.hashCode() * id;
    // Wersja na bazie porady J. Blocha:
    int result = 17;
    result = 37 * result + s.hashCode();
    result = 37 * result + id;
    return result;
  }
  public boolean equals(Object o) {
    return o instanceof CountedString &&
      s.equals(((CountedString)o).s) &&
      id == ((CountedString)o).id;
  }
  public static void main(String[] args) {
    Map<CountedString,Integer> map =
      new HashMap<CountedString,Integer>();
    CountedString[] cs = new CountedString[5];
    for(int i = 0; i < cs.length; i++) {
      cs[i] = new CountedString("hi");
      map.put(cs[i], i); // Pakowanie int -> Integer
    }
    print(map);
    for(CountedString cstring : cs) {
      print("Szukanie " + cstring);
      print(map.get(cstring));
    }
  }
} /* Output: (Sample)
{Cig: hi id: 4 hashCode(): 146450=3, Cig: hi id: 1 hashCode(): 146447=0, Cig: hi id: 3 hashCode(): 146449=2, Cig: hi id: 5 hashCode(): 146451=4, Cig: hi id: 2 hashCode(): 146448=1}
Szukanie Cig: hi id: 1 hashCode(): 146447
0
Szukanie Cig: hi id: 2 hashCode(): 146448
1
Szukanie Cig: hi id: 3 hashCode(): 146449
2
Szukanie Cig: hi id: 4 hashCode(): 146450
3
Szukanie Cig: hi id: 5 hashCode(): 146451
4
*///:~
