//: containers/Bits.java
// Kontener BitSet.
import java.util.*;
import static net.mindview.util.Print.*;

public class Bits {
  public static void printBitSet(BitSet b) {
    print("bity: " + b);
    StringBuilder bbits = new StringBuilder();
    for(int j = 0; j < b.size() ; j++)
      bbits.append(b.get(j) ? "1" : "0");
    print("wzorzec bitowy: " + bbits);
  }
  public static void main(String[] args) {
    Random rand = new Random(47);
    // Pobranie najmniej znaczcego bajta z nextInt():
    byte bt = (byte)rand.nextInt();
    BitSet bb = new BitSet();
    for(int i = 7; i >= 0; i--)
      if(((1 << i) &  bt) != 0)
        bb.set(i);
      else
        bb.clear(i);
    print("warto byte: " + bt);
    printBitSet(bb);

    short st = (short)rand.nextInt();
    BitSet bs = new BitSet();
    for(int i = 15; i >= 0; i--)
      if(((1 << i) &  st) != 0)
        bs.set(i);
      else
        bs.clear(i);
    print("warto short: " + st);
    printBitSet(bs);

    int it = rand.nextInt();
    BitSet bi = new BitSet();
    for(int i = 31; i >= 0; i--)
      if(((1 << i) &  it) != 0)
        bi.set(i);
      else
        bi.clear(i);
    print("warto int: " + it);
    printBitSet(bi);

    // testowanie zbiorw bitowych o ponad 64 bitach:
    BitSet b127 = new BitSet();
    b127.set(127);
    print("ustawienie bitu nr 127: " + b127);
    BitSet b255 = new BitSet(65);
    b255.set(255);
    print("ustawienie bitu nr 255: " + b255);
    BitSet b1023 = new BitSet(512);
    b1023.set(1023);
    b1023.set(1024);
    print("ustawienie bitu nr 1023: " + b1023);
  }
} /* Output:
warto byte: -107
bity: {0, 2, 4, 7}
wzorzec bitowy: 1010100100000000000000000000000000000000000000000000000000000000
warto short: 1302
bity: {1, 2, 4, 8, 10}
wzorzec bitowy: 0110100010100000000000000000000000000000000000000000000000000000
warto int: -2014573909
bity: {0, 1, 3, 5, 7, 9, 11, 18, 19, 21, 22, 23, 24, 25, 26, 31}
wzorzec bitowy: 1101010101010000001101111110000100000000000000000000000000000000
ustawienie bitu nr 127: {127}
ustawienie bitu nr 255: {255}
ustawienie bitu nr 1023: {1023, 1024}
*///:~
