//: concurrency/TestBlockingQueues.java
// {RunByHand}
import java.util.concurrent.*;
import java.io.*;
import static net.mindview.util.Print.*;

class LiftOffRunner implements Runnable {
  private BlockingQueue<LiftOff> rockets;
  public LiftOffRunner(BlockingQueue<LiftOff> queue) {
    rockets = queue;
  }
  public void add(LiftOff lo) {
    try {
      rockets.put(lo);
    } catch(InterruptedException e) {
      print("Przerwanie w metodzie put()");
    }
  }
  public void run() {
    try {
      while(!Thread.interrupted()) {
        LiftOff rocket = rockets.take();
        rocket.run(); // Uruchomienie zadania we wasnym wtku
      }
    } catch(InterruptedException e) {
      print("Obudzony z take()");
    }
    print("Koczenie zadania LiftOffRunner");
  }
}

public class TestBlockingQueues {
  static void getkey() {
    try {
      // Kompensacja rnicy pomidzy systemami Windows i Linux
      // odnonie znaku generowanego przez nacinicie klawisza Enter:
      new BufferedReader(
        new InputStreamReader(System.in)).readLine();
    } catch(java.io.IOException e) {
      throw new RuntimeException(e);
    }
  }
  static void getkey(String message) {
    print(message);
    getkey();
  }
  static void
  test(String msg, BlockingQueue<LiftOff> queue) {
    print(msg);
    LiftOffRunner runner = new LiftOffRunner(queue);
    Thread t = new Thread(runner);
    t.start();
    for(int i = 0; i < 5; i++)
      runner.add(new LiftOff(5));
    getkey("Nacinij 'Enter' (" + msg + ")");
    t.interrupt();
    print("Koniec testu " + msg);
  }
  public static void main(String[] args) {
    test("LinkedBlockingQueue", // Nieograniczony rozmiar
      new LinkedBlockingQueue<LiftOff>());
    test("ArrayBlockingQueue", // Stay rozmiar
      new ArrayBlockingQueue<LiftOff>(3));
    test("SynchronousQueue", // Kolejka jednoelementowa
      new SynchronousQueue<LiftOff>());
  }
} ///:~
