//: concurrency/SemaphoreDemo.java
// Test klasy Pool
import java.util.concurrent.*;
import java.util.*;
import static net.mindview.util.Print.*;

// Zadanie wyjmujce zasoby z puli:
class CheckoutTask<T> implements Runnable {
  private static int counter = 0;
  private final int id = counter++;
  private Pool<T> pool;
  public CheckoutTask(Pool<T> pool) {
    this.pool = pool;
  }
  public void run() {
    try {
      T item = pool.checkOut();
      print(this + "wyjmuje " + item);
      TimeUnit.SECONDS.sleep(1);
      print(this +"oddaje " + item);
      pool.checkIn(item);
    } catch(InterruptedException e) {
      // Dopuszczalny sposb przerwania zadania
    }
  }
  public String toString() {
    return "Zadanie CheckoutTask " + id + " ";
  }
}

public class SemaphoreDemo {
  final static int SIZE = 25;
  public static void main(String[] args) throws Exception {
    final Pool<Fat> pool =
      new Pool<Fat>(Fat.class, SIZE);
    ExecutorService exec = Executors.newCachedThreadPool();
    for(int i = 0; i < SIZE; i++)
      exec.execute(new CheckoutTask<Fat>(pool));
    print("Utworzono komplet zada CheckoutTasks");
    List<Fat> list = new ArrayList<Fat>();
    for(int i = 0; i < SIZE; i++) {
      Fat f = pool.checkOut();
      printnb(i + ": wtek metody main() wyjmuje z puli ");
      f.operation();
      list.add(f);
    }
    Future<?> blocked = exec.submit(new Runnable() {
      public void run() {
        try {
          // Semafor zapobiega dalszemu wyjmowaniu,
          // blokujc wywoanie:
          pool.checkOut();
        } catch(InterruptedException e) {
          print("Przerwanie w metodzie checkOut()");
        }
      }
    });
    TimeUnit.SECONDS.sleep(2);
    blocked.cancel(true); // Wyamanie z zablokowanego wywoania
    print("Oddawanie obiektw " + list);
    for(Fat f : list)
      pool.checkIn(f);
    for(Fat f : list)
      pool.checkIn(f); // Drugie wywoanie checkIn ignorowane
    exec.shutdown();
  }
} /* (Execute to see output) *///:~
