//: concurrency/MultiLock.java
// Jeden wtek moe wielokrotnie pozyskiwa t sam blokad.
import static net.mindview.util.Print.*;

public class MultiLock {
  public synchronized void f1(int count) {
    if(count-- > 0) {
      print("f1() wywouje f2() z licznikiem " + count);
      f2(count);
    }
  }
  public synchronized void f2(int count) {
    if(count-- > 0) {
      print("f2() wywouje f1() z licznikiem " + count);
      f1(count);
    }
  }
  public static void main(String[] args) throws Exception {
    final MultiLock multiLock = new MultiLock();
    new Thread() {
      public void run() {
        multiLock.f1(10);
      }
    }.start();
  }
} /* Output:
f1() wywouje f2() z licznikiem 9
f2() wywouje f1() z licznikiem 8
f1() wywouje f2() z licznikiem 7
f2() wywouje f1() z licznikiem 6
f1() wywouje f2() z licznikiem 5
f2() wywouje f1() z licznikiem 4
f1() wywouje f2() z licznikiem 3
f2() wywouje f1() z licznikiem 2
f1() wywouje f2() z licznikiem 1
f2() wywouje f1() z licznikiem 0
*///:~
