//: concurrency/Interrupting2.java
// Przerywanie zadania zawieszonego na blokadzie ReentrantLock.
import java.util.concurrent.*;
import java.util.concurrent.locks.*;
import static net.mindview.util.Print.*;

class BlockedMutex {
  private Lock lock = new ReentrantLock();
  public BlockedMutex() {
    // natychmiastowe zaoenie blokady w celu zademonstrowania
    // przerywania zadania zawieszonego na blokadzie ReentrantLock:
    lock.lock();
  }
  public void f() {
    try {
      // Blokada niedostpna dla drugiego zadania
      lock.lockInterruptibly(); // Wywoanie specjalne
      print("Zaoono blokad w f()");
    } catch(InterruptedException e) {
      print("Przerwanie zakadania blokady w f()");
    }
  }
}

class Blocked2 implements Runnable {
  BlockedMutex blocked = new BlockedMutex();
  public void run() {
    print("Oczekiwanie na f() w BlockedMutex");
    blocked.f();
    print("Wytrcony z zablokowanego wywoania");
  }
}

public class Interrupting2 {
  public static void main(String[] args) throws Exception {
    Thread t = new Thread(new Blocked2());
    t.start();
    TimeUnit.SECONDS.sleep(1);
    System.out.println("Wywoanie t.interrupt()");
    t.interrupt();
  }
} /* Output:
Oczekiwanie na f() w BlockedMutex
Wywoanie t.interrupt()
Przerwanie zakadania blokady w f()
Wytrcony z zablokowanego wywoania
*///:~
