//: concurrency/DaemonFromFactory.java
// Wykorzystanie wytwrni wtkw-demonw.
import java.util.concurrent.*;
import net.mindview.util.*;
import static net.mindview.util.Print.*;

public class DaemonFromFactory implements Runnable {
  public void run() {
    try {
      while(true) {
        TimeUnit.MILLISECONDS.sleep(100);
        print(Thread.currentThread() + " " + this);
      }
    } catch(InterruptedException e) {
      print("Przerwano!");
    }
  }
  public static void main(String[] args) throws Exception {
    ExecutorService exec = Executors.newCachedThreadPool(
      new DaemonThreadFactory());
    for(int i = 0; i < 10; i++)
      exec.execute(new DaemonFromFactory());
    print("Uruchomiono wszystkie demony");
    TimeUnit.MILLISECONDS.sleep(500); // Chwilowe upienie
  }
} /* (Execute to see output) *///:~
