//: concurrency/AttemptLocking.java
// Blokady z biblioteki wspbienoci pozwalaj na
// rezygnacj z przecigajcych si prb zakadania blokad.
import java.util.concurrent.*;
import java.util.concurrent.locks.*;

public class AttemptLocking {
  private ReentrantLock lock = new ReentrantLock();
  public void untimed() {
    boolean captured = lock.tryLock();
    try {
      System.out.println("tryLock(): " + captured);
    } finally {
      if(captured)
        lock.unlock();
    }
  }
  public void timed() {
    boolean captured = false;
    try {
      captured = lock.tryLock(2, TimeUnit.SECONDS);
    } catch(InterruptedException e) {
      throw new RuntimeException(e);
    }
    try {
      System.out.println("tryLock(2, TimeUnit.SECONDS): " +
        captured);
    } finally {
      if(captured)
        lock.unlock();
    }
  }
  public static void main(String[] args) {
    final AttemptLocking al = new AttemptLocking();
    al.untimed(); // True -- blokada dostpna
    al.timed();   // True -- blokada dostpna
    // Utworzenie osobnego zadania w celu zaoenia blokady:
    new Thread() {
      { setDaemon(true); }
      public void run() {
        al.lock.lock();
        System.out.println("zaoona");
      }
    }.start();
    Thread.yield(); // Dajmy szans drugiemu zadaniu
    al.untimed(); // False -- blokada zaoona przez zadanie
    al.timed();   // False -- blokada zaoona przez zadanie
  }
} /* Output:
tryLock(): true
tryLock(2, TimeUnit.SECONDS): true
zaoona
tryLock(): false
tryLock(2, TimeUnit.SECONDS): false
*///:~
