//: concurrency/ActiveObjectDemo.java
// Jako argumenty metod asynchronicznych mona przekazywa
// stae, wartoci niezmienne, obiekty "rozczone" albo
// inne obiekty aktywne.
import java.util.concurrent.*;
import java.util.*;
import static net.mindview.util.Print.*;

public class ActiveObjectDemo {
  private ExecutorService ex =
    Executors.newSingleThreadExecutor();
  private Random rand = new Random(47);
  // Losowe opnienie, dajce efekt
  // prowadzenia dugotrwaych oblicze:
  private void pause(int factor) {
    try {
      TimeUnit.MILLISECONDS.sleep(
        100 + rand.nextInt(factor));
    } catch(InterruptedException e) {
      print("Przerwanie zadania w sleep()");
    }
  }
  public Future<Integer>
  calculateInt(final int x, final int y) {
    return ex.submit(new Callable<Integer>() {
      public Integer call() {
        print("zaczynam " + x + " + " + y);
        pause(500);
        return x + y;
      }
    });
  }
  public Future<Float>
  calculateFloat(final float x, final float y) {
    return ex.submit(new Callable<Float>() {
      public Float call() {
        print("zaczynam " + x + " + " + y);
        pause(2000);
        return x + y;
      }
    });
  }
  public void shutdown() { ex.shutdown(); }
  public static void main(String[] args) {
    ActiveObjectDemo d1 = new ActiveObjectDemo();
    // Blokada wyjtku ConcurrentModificationException:
    List<Future<?>> results =
      new CopyOnWriteArrayList<Future<?>>();
    for(float f = 0.0f; f < 1.0f; f += 0.2f)
      results.add(d1.calculateFloat(f, f));
    for(int i = 0; i < 5; i++)
      results.add(d1.calculateInt(i, i));
    print("Wykonano wszystkie wywoania asynchroniczne");
    while(results.size() > 0) {
      for(Future<?> f : results)
        if(f.isDone()) {
          try {
            print(f.get());
          } catch(Exception e) {
            throw new RuntimeException(e);
          }
          results.remove(f);
        }
    }
    d1.shutdown();
  }
} /* Output: (85% match)
Wykonano wszystkie wywoania asynchroniczne
zaczynam 0.0 + 0.0
zaczynam 0.2 + 0.2
0.0
zaczynam 0.4 + 0.4
0.4
zaczynam 0.6 + 0.6
0.8
zaczynam 0.8 + 0.8
1.2
zaczynam 0 + 0
1.6
zaczynam 1 + 1
0
zaczynam 2 + 2
2
zaczynam 3 + 3
4
zaczynam 4 + 4
6
8
*///:~
