//: arrays/IceCream.java
// Zwraanie tablic z metod.
import java.util.*;

public class IceCream {
  private static Random rand = new Random(47);
  static final String[] FLAVORS = {
    "Czekoladowe", "Truskawkowe", "Karmel Waniliowy",
    "Mitowa Kostka", "Karmel Mokka-Migdaowy", "Rumowy Rodzynek",
    "Krem Pralinkowy", "Borwkowe Ciastko"
  };
  public static String[] flavorSet(int n) {
    if(n > FLAVORS.length)
      throw new IllegalArgumentException("Za duo smakw");
    String[] results = new String[n];
    boolean[] picked = new boolean[FLAVORS.length];
    for(int i = 0; i < n; i++) {
      int t;
      do
        t = rand.nextInt(FLAVORS.length);
      while(picked[t]);
      results[i] = FLAVORS[t];
      picked[t] = true;
    }
    return results;
  }
  public static void main(String[] args) {
    for(int i = 0; i < 7; i++)
      System.out.println(Arrays.toString(flavorSet(3)));
  }
} /* Output:
[Rumowy Rodzynek, Mitowa Kostka, Karmel Mokka-Migdaowy]
[Czekoladowe, Truskawkowe, Karmel Mokka-Migdaowy]
[Truskawkowe, Mitowa Kostka, Karmel Mokka-Migdaowy]
[Rumowy Rodzynek, Karmel Waniliowy, Borwkowe Ciastko]
[Karmel Waniliowy, Czekoladowe, Karmel Mokka-Migdaowy]
[Krem Pralinkowy, Truskawkowe, Karmel Mokka-Migdaowy]
[Karmel Mokka-Migdaowy, Truskawkowe, Mitowa Kostka]
*///:~
