//: c15:PrintableLogRecord.java
// Przesnieie metody toString() obiektu LogRecord
// Z ksiki 'Thinking in Java, 3rd ed.' (c) Bruce Eckel 2002
// www.BruceEckel.com. Patrz uwagi w pliku CopyRight.txt.
import com.bruceeckel.simpletest.*;
import java.util.ResourceBundle;
import java.util.logging.*;

public class PrintableLogRecord extends LogRecord {
  private static Test monitor = new Test();
  public PrintableLogRecord(Level level, String str) {
    super(level, str);
  }
  public String toString() {
    String result = "Poziom<" + getLevel() + ">\n"
      + "NazwaRejestratora<" + getLoggerName() + ">\n"
      + "Komunikat<" + getMessage() + ">\n"
      + "CzasWMilisekundach<" + getMillis() + ">\n"
      + "Parametry";
    Object[] objParams = getParameters();
    if(objParams == null)
      result += "<null>\n";
    else
      for(int i = 0; i < objParams.length; i++)
        result += "  Parametr # <" + i + " warto " +
          objParams[i].toString() + ">\n";
    result += "GrupaZasobw<" + getResourceBundle()
      + ">\nNazwaGrupyZasobw<" + getResourceBundleName()
      + ">\nNumerSekwencji<" + getSequenceNumber()
      + ">\nNazwaKlasyrdowej<" + getSourceClassName()
      + ">\nNazwaMetodyrdowej<" + getSourceMethodName()
      + ">\nId Wtku<" + getThreadID()
      + ">\nWyjtek<" + getThrown() + ">";
    return result;
  }
  public static void main(String[] args) {
    PrintableLogRecord logRecord = new PrintableLogRecord(
      Level.FINEST, "Prosty rekord rejestracji");
    System.out.println(logRecord);
    monitor.expect(new String[] {
      "Poziom<FINEST>",
      "NazwaRejestratora<null>",
      "Komunikat<Prosty rekord rejestracji>",
      "%% CzasWMilisekundach<.+>",
      "Parametry<null>",
      "GrupaZasobw<null>",
      "NazwaGrupyZasobw<null>",
      "NumerSekwencji<0>",
      "NazwaKlasyrdowej<null>",
      "NazwaMetodyrdowej<null>",
      "Id Wtku<10>",
      "Wyjtek<null>"
    });
  }
} ///:~
