//: c14:List.java
// <applet code=List width=250 height=375></applet>
// Z ksiki 'Thinking in Java, 3rd ed.' (c) Bruce Eckel 2002
// www.BruceEckel.com. Patrz uwagi w pliku CopyRight.txt.
import javax.swing.*;
import javax.swing.event.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.border.*;
import com.bruceeckel.swing.*;

public class List extends JApplet {
  private String[] flavors = {
    "Czekoladowe", "Truskawkowe", "Waniliowe", 
    "Mitowe", "Mocca", "Rumowe",
    "Karmelowe", "Bakaliowe"
  };
  private DefaultListModel lItems=new DefaultListModel();
  private JList lst = new JList(lItems);
  private JTextArea t =
    new JTextArea(flavors.length, 20);
  private JButton b = new JButton("Dodaj element");
  private ActionListener bl = new ActionListener() {
    public void actionPerformed(ActionEvent e) {
      if(count < flavors.length) {
        lItems.add(0, flavors[count++]);
      } else {
        // Wycz poniewa nie ma ju wicej 
        // smakw do dodania do listy.
        b.setEnabled(false);
      }
    }
  };
  private ListSelectionListener ll =
    new ListSelectionListener() {
      public void valueChanged(ListSelectionEvent e) {
        if(e.getValueIsAdjusting()) return;
        t.setText("");
        Object[] items=lst.getSelectedValues();
        for(int i = 0; i < items.length; i++)
          t.append(items[i] + "\n");
      }
    };
  private int count = 0;
  public void init() {
    Container cp = getContentPane();
    t.setEditable(false);
    cp.setLayout(new FlowLayout());
    // Ustaw komponentom ramki.
    Border brd = BorderFactory.createMatteBorder(
      1, 1, 2, 2, Color.BLACK);
    lst.setBorder(brd);
    t.setBorder(brd);
    // Dodaj do listy cztery pierwsze elementy.
    for(int i = 0; i < 4; i++)
      lItems.addElement(flavors[count++]);
    // Dodaj elementy do panelu 
    cp.add(t);
    cp.add(lst);
    cp.add(b);
    // Zarejestruj odbiorcw zdarze.
    lst.addListSelectionListener(ll);
    b.addActionListener(bl);
  }
  public static void main(String[] args) {
    Console.run(new List(), 250, 375);
  }
} ///:~