//: c14:InvokeLaterFrame.java
// Eliminacja warunkw czasowych podczas korzystania z komponentw Swing.
// Z ksiki 'Thinking in Java, 3rd ed.' (c) Bruce Eckel 2002
// www.BruceEckel.com. Patrz uwagi w pliku CopyRight.txt.
import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import com.bruceeckel.swing.Console;

public class InvokeLaterFrame extends JFrame {
  private JTextField statusField =
    new JTextField("Warto pocztkoa");
  public InvokeLaterFrame() {
    Container cp = getContentPane();
    cp.add(statusField, BorderLayout.NORTH);
    addWindowListener(new WindowAdapter() {
      public void windowOpened(WindowEvent e) {
        try { // Symulacja narzutu czasowego inicjalizacji
          Thread.sleep(2000);
        } catch (InterruptedException ex) {
           throw new RuntimeException(ex);
        }
        statusField.setText("Inicjalizacja zakoczona");
      }
    });
  }
  public static void main(String[] args) {
    final InvokeLaterFrame ilf = new InvokeLaterFrame();
    Console.run(ilf, 150, 60);
    // Wywoaj invokeAndWait() aby zsynchronizowa wyjcie komunikatu:
    // SwingUtilities.invokeAndWait(new Runnable() {
    SwingUtilities.invokeLater(new Runnable() {
      public void run() {
        ilf.statusField.setText("Aplikacja gotowa");
      }
    });
    System.out.println("Koniec");
  }
} ///:~
