//: c13:SyncObject.java
// Synchronizacja w oparciu o inny obiekt
// Z ksiki 'Thinking in Java, 3rd ed.' (c) Bruce Eckel 2002
// www.BruceEckel.com. Patrz uwagi w pliku CopyRight.txt.
import com.bruceeckel.simpletest.*;

class DualSynch {
  private Object syncObject = new Object();
  public synchronized void f() {
    System.out.println("Wewntrz f()");
    // Blokada nie jest zwalniana:
    try {
      Thread.sleep(500);
    } catch(InterruptedException e) {
      throw new RuntimeException(e);
    }
    System.out.println("Opuszczamy f()");
  }
  public void g() {
    synchronized(syncObject) {
      System.out.println("Wewntrz g()");
      try {
        Thread.sleep(500);
      } catch(InterruptedException e) {
        throw new RuntimeException(e);
      }
      System.out.println("Opuszczamy g()");
    }
  }
}

public class SyncObject {
  private static Test monitor = new Test();
  public static void main(String[] args) {
    final DualSynch ds = new DualSynch();
    new Thread() {
      public void run() {
        ds.f();
      }
    }.start();
    ds.g();
    monitor.expect(new String[] {
      "Wewntrz g()",
      "Wewntrz f()",
      "Opuszczamy g()",
      "Opuszczamy f()"
    }, Test.WAIT + Test.IGNORE_ORDER);
  }
} ///:~
